const nodemailer = require('nodemailer');
require('dotenv').config();

const transporter = nodemailer.createTransport({
  host: process.env.EMAIL_HOST,
  port: process.env.EMAIL_PORT,
  secure: false,
  auth: {
    user: process.env.EMAIL_USER,
    pass: process.env.EMAIL_PASS
  }
});

async function sendNotificationEmail(toEmail, senderCode) {
  const mailOptions = {
    from: process.env.EMAIL_FROM,
    to: toEmail,
    subject: 'Your Analytics Report is Ready',
    html: `
      <div style="font-family: Arial, sans-serif; padding: 20px;">
        <h2>Analytics Dashboard Update</h2>
        <p>Your requested analytics report has been updated with new data.</p>
        <p>Report ID: ${Date.now().toString(36).toUpperCase()}</p>
        <p>Generated at: ${new Date().toLocaleString()}</p>
        <a href="${process.env.FRONTEND_URL}" style="display: inline-block; padding: 10px 20px; background-color: #007bff; color: white; text-decoration: none; border-radius: 5px;">View Dashboard</a>
        <p style="color: #666; font-size: 12px; margin-top: 20px;">This is an automated message. Please do not reply.</p>
      </div>
    `
  };

  try {
    await transporter.sendMail(mailOptions);
    console.log('Notification email sent');
  } catch (error) {
    console.error('Email error:', error);
  }
}

// General email sending function
async function sendEmail(to, subject, html) {
  const mailOptions = {
    from: process.env.EMAIL_USER,
    to,
    subject,
    html
  };

  try {
    await transporter.sendMail(mailOptions);
    console.log(`Email sent to ${to}: ${subject}`);
  } catch (error) {
    console.error('Email send error:', error);
    throw error;
  }
}

module.exports = { sendNotificationEmail, sendEmail };