const sqlite3 = require('sqlite3').verbose();
const bcrypt = require('bcrypt');
const fs = require('fs');
const path = require('path');

const db = new sqlite3.Database('./chat.db');

// Create uploads directory
const uploadsDir = path.join(__dirname, 'uploads');
if (!fs.existsSync(uploadsDir)) {
  fs.mkdirSync(uploadsDir);
}

// Initialize database
db.serialize(() => {
  // Access codes table
  db.run(`CREATE TABLE IF NOT EXISTS access_codes (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    code TEXT UNIQUE NOT NULL,
    room_id TEXT NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
  )`);

  // Messages table with type field
  db.run(`CREATE TABLE IF NOT EXISTS messages (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    room_id TEXT NOT NULL,
    sender_code TEXT NOT NULL,
    message_type TEXT DEFAULT 'text',
    encrypted_message TEXT NOT NULL,
    file_path TEXT,
    timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
  )`);

  // User sessions table
  db.run(`CREATE TABLE IF NOT EXISTS user_sessions (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    code TEXT NOT NULL,
    email TEXT,
    last_seen DATETIME DEFAULT CURRENT_TIMESTAMP,
    is_online BOOLEAN DEFAULT 0
  )`);
});

// Generate access codes
async function generateAccessCodes() {
  const codes = [
    { code: 'ILY2102', room: 'room_001', email: 'wolfganggermain1@gmail.com' },
    { code: 'ILY1709', room: 'room_001', email: 'kaboreanais54@gmail.com' }
  ];

  for (const { code, room, email } of codes) {
    const hashedCode = await bcrypt.hash(code, 10);
    db.run(
      'INSERT OR IGNORE INTO access_codes (code, room_id) VALUES (?, ?)',
      [code, room]
    );
    db.run(
      'INSERT OR IGNORE INTO user_sessions (code, email) VALUES (?, ?)',
      [code, email]
    );
  }
}

generateAccessCodes();

module.exports = db;